/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.AbstractHTTPJwtAuthenticator;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.KeyProvider;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.KeySetRetriever;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.OidcProviderConfig;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.OpenIdProviderClient;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.SelfRefreshingKeySet;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchsupport.action.Responses;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.xcontent.ObjectTreeXContent;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;

@Deprecated
public class HTTPJwtKeyByOpenIdConnectAuthenticator
extends AbstractHTTPJwtAuthenticator {
    private static final Logger log = LogManager.getLogger(HTTPJwtKeyByOpenIdConnectAuthenticator.class);
    private ProxyConfig proxyConfig;
    private OpenIdProviderClient openIdProviderClient;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "oidc", HTTPJwtKeyByOpenIdConnectAuthenticator.class).initialized().requiresEnterpriseLicense();
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "openid";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPJwtKeyByOpenIdConnectAuthenticator::new);
        }
    };

    public HTTPJwtKeyByOpenIdConnectAuthenticator(Settings settings, Path configPath) {
        super(settings, configPath);
    }

    @Override
    protected KeyProvider initKeyProvider(Settings settings, Path configPath) throws Exception {
        int idpRequestTimeoutMs;
        this.proxyConfig = ProxyConfig.parse((Map)ObjectTreeXContent.toMap((ToXContent)settings), (String)"proxy");
        try {
            this.openIdProviderClient = new OpenIdProviderClient(URI.create(settings.get("openid_connect_url")), HTTPJwtKeyByOpenIdConnectAuthenticator.getSSLConfig(settings, configPath), this.proxyConfig, settings.getAsBoolean("cache_jwks_endpoint", Boolean.valueOf(false)));
            idpRequestTimeoutMs = settings.getAsInt("idp_request_timeout_ms", Integer.valueOf(5000));
            this.openIdProviderClient.setRequestTimeoutMs(idpRequestTimeoutMs);
        }
        catch (SettingsBasedSSLConfigurator.SSLConfigException e) {
            log.error("Error while initializing openid http authenticator", (Throwable)e);
            throw new RuntimeException("Error while initializing openid http authenticator", e);
        }
        idpRequestTimeoutMs = settings.getAsInt("idp_request_timeout_ms", Integer.valueOf(5000));
        int idpQueuedThreadTimeoutMs = settings.getAsInt("idp_queued_thread_timeout_ms", Integer.valueOf(2500));
        int refreshRateLimitTimeWindowMs = settings.getAsInt("refresh_rate_limit_time_window_ms", Integer.valueOf(10000));
        int refreshRateLimitCount = settings.getAsInt("refresh_rate_limit_count", Integer.valueOf(10));
        KeySetRetriever keySetRetriever = new KeySetRetriever(this.openIdProviderClient);
        SelfRefreshingKeySet selfRefreshingKeySet = new SelfRefreshingKeySet(keySetRetriever);
        selfRefreshingKeySet.setRequestTimeoutMs(idpRequestTimeoutMs);
        selfRefreshingKeySet.setQueuedThreadTimeoutMs(idpQueuedThreadTimeoutMs);
        selfRefreshingKeySet.setRefreshRateLimitTimeWindowMs(refreshRateLimitTimeWindowMs);
        selfRefreshingKeySet.setRefreshRateLimitCount(refreshRateLimitCount);
        return selfRefreshingKeySet;
    }

    private static SettingsBasedSSLConfigurator.SSLConfig getSSLConfig(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        return new SettingsBasedSSLConfigurator(settings, configPath, "openid_connect_idp").buildSSLConfig();
    }

    public boolean handleMetaRequest(RestRequest restRequest, RestChannel restChannel, String generalRequestPathComponent, String specificRequestPathComponent, ThreadContext threadContext) {
        try {
            if ("config".equals(specificRequestPathComponent)) {
                OidcProviderConfig oidcProviderConfig = this.openIdProviderClient.getOidcConfiguration();
                HashMap<String, Object> oidcProviderConfigMap = new HashMap<String, Object>(oidcProviderConfig.getParsedJson());
                oidcProviderConfigMap.put("token_endpoint_proxy", generalRequestPathComponent + "/token");
                Responses.send((RestChannel)restChannel, (RestStatus)RestStatus.OK, oidcProviderConfigMap);
            } else if ("token".equals(specificRequestPathComponent)) {
                ContentType contentType = ContentType.APPLICATION_FORM_URLENCODED;
                byte[] content = BytesReference.toBytes((BytesReference)restRequest.content());
                HttpResponse idpResponse = this.openIdProviderClient.callTokenEndpoint(content, contentType);
                byte[] idpResponseContent = EntityUtils.toByteArray((HttpEntity)idpResponse.getEntity());
                if (idpResponse.getStatusLine().getStatusCode() >= 400) {
                    log.warn("Got error from IDP for token endpoint:\n" + this.openIdProviderClient.getOidcConfiguration().getTokenEndpoint() + "\n" + new String(content) + "\n" + idpResponse.getStatusLine() + "\n" + Arrays.asList(idpResponse.getAllHeaders()) + "\n" + new String(idpResponseContent));
                }
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.fromCode((int)idpResponse.getStatusLine().getStatusCode()), idpResponse.getEntity().getContentType().getValue(), idpResponseContent));
            } else {
                Responses.sendError((RestChannel)restChannel, (RestStatus)RestStatus.NOT_FOUND, (String)("Invalid endpoint: " + restRequest.path()));
            }
            return true;
        }
        catch (Exception e) {
            log.error("Error while handling request", (Throwable)e);
            Responses.sendError((RestChannel)restChannel, (RestStatus)RestStatus.INTERNAL_SERVER_ERROR, (String)"Error while handling OpenID request");
            return true;
        }
    }

    public String getType() {
        return "openid";
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

